package de.uniba.minf.registry.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper=true)
@NoArgsConstructor
public class IntegerPropertyValue extends BasePropertyValue<Integer> {
	private static final long serialVersionUID = 2071169075253745021L;

	public IntegerPropertyValue(Integer value) {
		this.setValue(value);
	}
	
	public IntegerPropertyValue(Integer value, String lang) {
		this.setValue(value);
		this.setLang(lang);
	}
	
	@Override
	public boolean asBoolean() {
		return this.getValue()==1;
	}
}
