package de.uniba.minf.registry.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper=true)
@NoArgsConstructor
public class DoublePropertyValue extends BasePropertyValue<Double> {
	private static final long serialVersionUID = 1058066358355942628L;

	public DoublePropertyValue(Double value) {
		this.setValue(value);
	}
	
	public DoublePropertyValue(Double value, String lang) {
		this.setValue(value);
		this.setLang(lang);
	}
	
	@Override
	public boolean asBoolean() {
		return this.getValue()==1.0;
	}
}
