package de.uniba.minf.registry.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=false)
public class CompositePropertyImpl extends PropertyImpl {
	
	private static final long serialVersionUID = -8393661481293626596L;

	@Transient
	private boolean layersOnly;
	
	@Transient
	@JsonIgnore
	private Map<String, Property> layeredPropertyMap;
	
	private String preferredLayerEntityId;
	
	@Override 
	public boolean isComposite() { return true; }
	
	public List<String> getLayersForPropertyValue(Object value) {
		if (value==null || layeredPropertyMap==null) {
			return new ArrayList<>(0);
		}
		List<String> layerIds = new ArrayList<>();
		for (Entry<String, Property> propertyLayerEntry : layeredPropertyMap.entrySet()) {
			if (propertyLayerEntry.getValue().valuesAsList().stream().anyMatch(v -> v.asText().equals(value.toString()))) {
				layerIds.add(propertyLayerEntry.getKey());
			}
		}
		return layerIds;
	}
}
