/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.vocabulary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.vocabulary.Reference;
import de.uniba.minf.registry.model.vocabulary.ValueVariant;
import java.util.List;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@CompoundIndex(def="{'definitionName': 1, 'key': 1}", unique=true)
public class VocabularyEntry
extends BaseDefinedObject
implements Identifiable {
    private static final long serialVersionUID = -6473574071976021721L;
    @Indexed
    private String key;
    private String primaryValue;
    @Transient
    @JsonIgnore
    private double score;
    private List<ValueVariant> variants;
    private List<Reference> references;

    public String getKey() {
        return this.key;
    }

    public String getPrimaryValue() {
        return this.primaryValue;
    }

    public double getScore() {
        return this.score;
    }

    public List<ValueVariant> getVariants() {
        return this.variants;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPrimaryValue(String primaryValue) {
        this.primaryValue = primaryValue;
    }

    @JsonIgnore
    public void setScore(double score) {
        this.score = score;
    }

    public void setVariants(List<ValueVariant> variants) {
        this.variants = variants;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VocabularyEntry)) {
            return false;
        }
        VocabularyEntry other = (VocabularyEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getScore(), other.getScore()) != 0) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$primaryValue = this.getPrimaryValue();
        String other$primaryValue = other.getPrimaryValue();
        if (this$primaryValue == null ? other$primaryValue != null : !this$primaryValue.equals(other$primaryValue)) {
            return false;
        }
        List<ValueVariant> this$variants = this.getVariants();
        List<ValueVariant> other$variants = other.getVariants();
        if (this$variants == null ? other$variants != null : !((Object)this$variants).equals(other$variants)) {
            return false;
        }
        List<Reference> this$references = this.getReferences();
        List<Reference> other$references = other.getReferences();
        return !(this$references == null ? other$references != null : !((Object)this$references).equals(other$references));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VocabularyEntry;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $score = Double.doubleToLongBits(this.getScore());
        result = result * 59 + (int)($score >>> 32 ^ $score);
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $primaryValue = this.getPrimaryValue();
        result = result * 59 + ($primaryValue == null ? 43 : $primaryValue.hashCode());
        List<ValueVariant> $variants = this.getVariants();
        result = result * 59 + ($variants == null ? 43 : ((Object)$variants).hashCode());
        List<Reference> $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "VocabularyEntry(super=" + super.toString() + ", key=" + this.getKey() + ", primaryValue=" + this.getPrimaryValue() + ", score=" + this.getScore() + ", variants=" + this.getVariants() + ", references=" + this.getReferences() + ")";
    }
}

