/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.vocabulary;

import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class VocabularyDefinition
extends BaseDefinition {
    private static final long serialVersionUID = -5798171298877689887L;

    @Override
    public List<PropertyDefinition> getPreviewProperties() {
        ArrayList<PropertyDefinition> previewProperties = new ArrayList<PropertyDefinition>();
        previewProperties.add(this.createProperty("key"));
        previewProperties.add(this.createProperty("primaryValue"));
        previewProperties.addAll(super.getPreviewProperties());
        return previewProperties;
    }

    private PropertyDefinition createProperty(String label) {
        SimplePropertyDefinition p = new SimplePropertyDefinition();
        p.setName(label);
        p.setIdentifier(this.getName() + "." + label);
        p.setType(SimplePropertyDefinition.SIMPLE_TYPES.TEXT);
        return p;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VocabularyDefinition)) {
            return false;
        }
        VocabularyDefinition other = (VocabularyDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VocabularyDefinition;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "VocabularyDefinition(super=" + super.toString() + ")";
    }
}

