/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.validation.constraints;

import am.ik.yavi.core.CustomConstraint;
import de.uniba.minf.registry.model.PropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiplicityConstraint<T>
implements CustomConstraint<List<T>> {
    private final Integer min;
    private final Integer max;

    public static <T> MultiplicityConstraint<T> fromMin(int min) {
        return new MultiplicityConstraint<T>(min, null);
    }

    public static <T> MultiplicityConstraint<T> fromMax(int max) {
        return new MultiplicityConstraint<T>(null, max);
    }

    public static <T> MultiplicityConstraint<T> fromMinAndMax(int min, int max) {
        return new MultiplicityConstraint<T>(min, max);
    }

    private MultiplicityConstraint(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    public boolean test(List<T> c) {
        return !((c != null && !c.isEmpty() || this.min != null && this.min != 0) && (c == null || c.isEmpty() || this.min != null && c.size() < this.min || this.max != null && !this.checkLteMax(c, this.max)));
    }

    private boolean checkLteMax(List<T> c, int max) {
        if (c.size() <= max) {
            return true;
        }
        HashMap<Object, List<Object>> perKeyMap = new HashMap<Object, List<Object>>();
        for (T value : c) {
            if (PropertyValue.class.isAssignableFrom(value.getClass())) {
                PropertyValue pv = (PropertyValue)PropertyValue.class.cast(value);
                pv.valuesAsList().stream().forEach(v -> this.putOrAdd(pv.getLang(), v, perKeyMap));
                continue;
            }
            this.putOrAdd(null, value, perKeyMap);
        }
        for (List valuesPerKey : perKeyMap.values()) {
            if (valuesPerKey.size() <= max) continue;
            return false;
        }
        return true;
    }

    public void putOrAdd(Object key, Object value, Map<Object, List<Object>> c) {
        List<Object> v;
        if (c.containsKey(key)) {
            v = c.get(key);
        } else {
            v = new ArrayList();
            c.put(key, v);
        }
        v.add(value);
    }

    public String messageKey() {
        if (this.min == null && this.max == null) {
            return null;
        }
        if (this.min == null) {
            return "property.multiplicity.max";
        }
        if (this.max == null) {
            return "property.multiplicity.min";
        }
        if (this.min.equals(this.max)) {
            return "property.multiplicity.fixed";
        }
        if (this.min == 0 && this.max == 1) {
            return "property.multiplicity.none";
        }
        return "property.multiplicity.minmax";
    }

    public String defaultMessageFormat() {
        if (this.min == null && this.max == null) {
            return null;
        }
        if (this.min == null) {
            return "\"{0}\" has a specified multiplicity of max {2}";
        }
        if (this.max == null) {
            return "\"{0}\" has a specified multiplicity of min {1}";
        }
        if (this.min.equals(this.max)) {
            return "\"{0}\" has a specified multiplicity of exactly {2}";
        }
        if (this.min == 0 && this.max == 1) {
            return "\"{0}\" does not allow multiplicity";
        }
        return "\"{0}\" has a specified multiplicity of min {1} and max {2}";
    }

    public Object[] arguments(List<T> violatedValue) {
        return new Object[]{this.min, this.max};
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiplicityConstraint)) {
            return false;
        }
        MultiplicityConstraint other = (MultiplicityConstraint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$min = this.getMin();
        Integer other$min = other.getMin();
        if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
            return false;
        }
        Integer this$max = this.getMax();
        Integer other$max = other.getMax();
        return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiplicityConstraint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
        Integer $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        return result;
    }

    public String toString() {
        return "MultiplicityConstraint(min=" + this.getMin() + ", max=" + this.getMax() + ")";
    }
}

