/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.validation;

import am.ik.yavi.core.CustomConstraint;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryVocabularyConstraint
implements CustomConstraint<String> {
    private static final Logger log = LoggerFactory.getLogger(QueryVocabularyConstraint.class);
    private final VocabularyLookupService vocabularyLookupService;
    private final AutoqueryEntityLookupService autoqueryLookupService;
    private final ValidationEntityService entityService;
    private final String vocabulary;
    private final boolean entity;

    public QueryVocabularyConstraint(String vocabulary, VocabularyLookupService vocabularyLookupService, AutoqueryEntityLookupService autoqueryLookupService, ValidationEntityService entityService, boolean entity) {
        this.vocabulary = vocabulary;
        this.vocabularyLookupService = vocabularyLookupService;
        this.autoqueryLookupService = autoqueryLookupService;
        this.entityService = entityService;
        this.entity = entity;
    }

    public boolean test(String id) {
        try {
            if (!this.entity) {
                return this.vocabularyLookupService.canResolveId(this.vocabulary, id);
            }
            if (this.entityService.findLatestByEntityId(id).isPresent()) {
                return true;
            }
            if (!this.entityService.findByExternalIdentifier(this.vocabulary, id).isEmpty()) {
                return true;
            }
            return this.autoqueryLookupService.canResolveId(this.vocabulary, id);
        }
        catch (VocabularyLookupException e) {
            log.error("Failed to resolve vocabulary entry", (Throwable)e);
            return false;
        }
    }

    public String messageKey() {
        return "value.vocabulary_key_unknown";
    }

    public String defaultMessageFormat() {
        return "Selection of a valid vocabulary entry required";
    }
}

