/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.validation;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.CollectionConstraint;
import am.ik.yavi.core.ViolationMessage;
import de.uniba.minf.registry.model.BasePropertyValue;
import de.uniba.minf.registry.model.BooleanPropertyValue;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.MissingPropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.validation.NumParamConstraint;
import de.uniba.minf.registry.model.validation.PropertyValueValidator;
import de.uniba.minf.registry.model.validation.ValidationConstants;
import de.uniba.minf.registry.model.validation.constraints.MandatoryConstraint;
import de.uniba.minf.registry.model.validation.constraints.MultiplicityConstraint;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PropertyValidator
extends ValidatorBuilder<Property> {
    private final List<ValidationConfigurationException> configurationExceptions = new ArrayList<ValidationConfigurationException>();
    private final VocabularyLookupService vocabularyLookupService;
    private final ValidationEntityService entityService;
    private final AutoqueryEntityLookupService autoqueryLookupService;

    public PropertyValidator(PropertyDefinition pd, VocabularyLookupService vocabularyLookupService, AutoqueryEntityLookupService autoqueryLookupService, ValidationEntityService entityService, boolean skipCompleteness) {
        this.vocabularyLookupService = vocabularyLookupService;
        this.entityService = entityService;
        this.autoqueryLookupService = autoqueryLookupService;
        this.buildValidation(pd, skipCompleteness);
    }

    private void buildValidation(PropertyDefinition pd, boolean skipCompleteness) {
        try {
            if (pd.isHierarchical()) {
                this.buildHierarchicalPropertyValidation(pd, skipCompleteness);
            } else {
                this.buildSimplePropertyValidation(pd, skipCompleteness);
            }
        }
        catch (ValidationConfigurationException ex) {
            this.configurationExceptions.add(ex);
        }
    }

    private void buildHierarchicalPropertyValidation(PropertyDefinition pd, boolean skipCompleteness) throws ValidationConfigurationException {
        Optional mandatoryRestriction;
        Optional multiplicityRestriction;
        if (!skipCompleteness && (multiplicityRestriction = this.getMultiplicityRestriction(pd)).isPresent()) {
            this.constraintOnCondition((property, constraintGroup) -> property.getProperties() != null && !property.getProperties().isEmpty(), p -> p._collection(Property::getProperties, pd.getName() + "._multiplicity", c -> (CollectionConstraint)multiplicityRestriction.get()));
        }
        if (!skipCompleteness && (mandatoryRestriction = this.getMandatoryRestriction(pd)).isPresent()) {
            this.constraintOnCondition((property, constraintGroup) -> property.getProperties() != null && property.getProperties().isEmpty(), p -> p._collection(Property::getProperties, pd.getName() + "._mandatory", c -> (CollectionConstraint)mandatoryRestriction.get()));
        }
        ValidatorBuilder propListValidatorBuilder = ValidatorBuilder.of(PropertyList.class);
        for (PropertyDefinition subPd : ((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(pd)).getProperties()) {
            PropertyValidator pv = new PropertyValidator(subPd, this.vocabularyLookupService, this.getAutoqueryLookupService(), this.entityService, skipCompleteness);
            propListValidatorBuilder.nest(e -> e.get(subPd.getName()), "_prop", pv.build());
            this.configurationExceptions.addAll(pv.getConfigurationExceptions());
        }
        this.forEach(Property::getProperties, pd.getName(), propListValidatorBuilder.build());
    }

    private void buildSimplePropertyValidation(PropertyDefinition pd, boolean skipCompleteness) throws ValidationConfigurationException {
        PropertyValueValidator<BasePropertyValue> propertyValueValidator;
        ValidatorBuilder valueListValidatorBuilder;
        Optional mandatoryRestriction;
        Optional multiplicityRestriction;
        if (!skipCompleteness && (multiplicityRestriction = this.getMultiplicityRestriction(pd)).isPresent()) {
            this.constraintOnCondition((property, constraintGroup) -> !property.valuesAsList().isEmpty(), p -> p._collection(Property::valuesAsList, pd.getName() + "._multiplicity", c -> (CollectionConstraint)multiplicityRestriction.get()));
        }
        if (!skipCompleteness && (mandatoryRestriction = this.getMandatoryRestriction(pd)).isPresent()) {
            this.constraintOnCondition((property, constraintGroup) -> property.valuesAsList().isEmpty(), p -> p._collection(Property::valuesAsList, pd.getName() + "._mandatory", c -> (CollectionConstraint)mandatoryRestriction.get()));
        }
        if (pd.isVocabulary()) {
            VocabularyPropertyDefinition vpd = (VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(pd);
            valueListValidatorBuilder = ValidatorBuilder.of(PropertyValueList.class);
            propertyValueValidator = new PropertyValueValidator<TextPropertyValue>(TextPropertyValue.class, vpd, this.vocabularyLookupService, this.getAutoqueryLookupService(), this.entityService);
            this.appendValueValidation(vpd, (ValidatorBuilder<PropertyValueList>)valueListValidatorBuilder, propertyValueValidator);
        }
        if (pd.isSimple()) {
            SimplePropertyDefinition spd = (SimplePropertyDefinition)SimplePropertyDefinition.class.cast(pd);
            if (pd.isValidated() || !spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.TEXT)) {
                valueListValidatorBuilder = ValidatorBuilder.of(PropertyValueList.class);
                if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.INT) || spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.DATE)) {
                    propertyValueValidator = new PropertyValueValidator<IntegerPropertyValue>(IntegerPropertyValue.class, spd);
                    this.appendTypeValidation(IntegerPropertyValue.class, spd, (ValidatorBuilder<PropertyValueList>)valueListValidatorBuilder);
                } else if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN)) {
                    propertyValueValidator = new PropertyValueValidator<BooleanPropertyValue>(BooleanPropertyValue.class, spd);
                    this.appendTypeValidation(BooleanPropertyValue.class, spd, (ValidatorBuilder<PropertyValueList>)valueListValidatorBuilder);
                } else if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.FLOAT)) {
                    propertyValueValidator = new PropertyValueValidator<DoublePropertyValue>(DoublePropertyValue.class, spd);
                    this.appendTypeValidation(DoublePropertyValue.class, spd, (ValidatorBuilder<PropertyValueList>)valueListValidatorBuilder);
                } else {
                    propertyValueValidator = new PropertyValueValidator<TextPropertyValue>(TextPropertyValue.class, spd);
                }
                this.appendValueValidation(spd, (ValidatorBuilder<PropertyValueList>)valueListValidatorBuilder, propertyValueValidator);
            }
        }
    }

    private void appendValueValidation(PropertyDefinition pd, ValidatorBuilder<PropertyValueList> valueListValidatorBuilder, PropertyValueValidator<? extends BasePropertyValue<?>> propertyValueValidator) {
        this.appendPropertyValueValidation(pd, valueListValidatorBuilder, propertyValueValidator);
        this.constraintOnCondition((value, constraintGroup) -> value.getValue() != null && PropertyValueList.class.isAssignableFrom(value.getValue().getClass()), c -> c.nest(v -> (PropertyValueList)PropertyValueList.class.cast(v.getValue()), "_prop", valueListValidatorBuilder.build()));
    }

    private void appendTypeValidation(Class<?> checkClass, SimplePropertyDefinition spd, ValidatorBuilder<PropertyValueList> valueListValidatorBuilder) {
        ValidationConstants.CustomViolationMessages violationMessage = this.findViolationMessage(checkClass);
        this.constraintOnCondition((value, constraintGroup) -> !MissingPropertyValue.class.isAssignableFrom(value.getValue().getClass()) && !PropertyValueList.class.isAssignableFrom(value.getValue().getClass()), c -> c.constraintOnTarget(v -> checkClass.isAssignableFrom(v.getValue().getClass()), spd.getName() + "._val", (ViolationMessage)violationMessage));
        valueListValidatorBuilder.forEach(PropertyValueList::getValues, spd.getName(), c -> c.constraintOnTarget(v -> checkClass.isAssignableFrom(v.getClass()), "_val", (ViolationMessage)violationMessage));
    }

    private ValidationConstants.CustomViolationMessages findViolationMessage(Class<?> checkClass) {
        for (ValidationConstants.CustomViolationMessages iViolationMessage : ValidationConstants.CustomViolationMessages.values()) {
            if (!iViolationMessage.key().equals("checkClass:" + checkClass.getSimpleName())) continue;
            return iViolationMessage;
        }
        return null;
    }

    private void appendPropertyValueValidation(PropertyDefinition pd, ValidatorBuilder<PropertyValueList> valueListValidatorBuilder, PropertyValueValidator propertyValueValidator) {
        this.constraintOnCondition((value, constraintGroup) -> value.getValue() != null && propertyValueValidator.getValidatedClass().isAssignableFrom(value.getValue().getClass()), c -> c.nest(v -> propertyValueValidator.getValidatedClass().cast(v.getValue()), pd.getName() + "._val", propertyValueValidator.getValidator()));
        valueListValidatorBuilder.forEach(PropertyValueList::getValues, pd.getName(), c -> c.constraintOnCondition((value, constraintGroup) -> value != null && propertyValueValidator.getValidatedClass().isAssignableFrom(value.getClass()), c1 -> c1.nest(v -> propertyValueValidator.getValidatedClass().cast(v), "_val", propertyValueValidator.getValidator())));
    }

    private <T> Optional<CollectionConstraint<Property, List<T>, T>> getMandatoryRestriction(PropertyDefinition pd) throws ValidationConfigurationException {
        if (pd.isMandatory()) {
            return Optional.of((CollectionConstraint)new CollectionConstraint().predicate(new MandatoryConstraint()));
        }
        return Optional.empty();
    }

    private <T> Optional<CollectionConstraint<Property, List<T>, T>> getMultiplicityRestriction(PropertyDefinition pd) throws ValidationConfigurationException {
        if (pd.getMultiplicity() != null && pd.getMultiplicity().size() == 1 && pd.getMultiplicity().contains("true")) {
            return Optional.empty();
        }
        if (pd.getMultiplicity() == null || pd.getMultiplicity().isEmpty() || pd.getMultiplicity().contains("false")) {
            return Optional.of((CollectionConstraint)new CollectionConstraint().predicate(MultiplicityConstraint.fromMinAndMax(0, 1)));
        }
        return this.collectCustomMultiplicityConstraints(pd);
    }

    private <T> Optional<CollectionConstraint<Property, List<T>, T>> collectCustomMultiplicityConstraints(PropertyDefinition pd) throws ValidationConfigurationException {
        CollectionConstraint c = new CollectionConstraint();
        MinMaxBoundary minMax = this.getMinMaxForMultiplicity(pd);
        if (minMax.getMin() != null && minMax.getMax() != null) {
            c.predicate(MultiplicityConstraint.fromMinAndMax(minMax.getMin(), minMax.getMax()));
        } else if (minMax.getMin() != null) {
            c.predicate(MultiplicityConstraint.fromMin(minMax.getMin()));
        } else if (minMax.getMax() != null) {
            c.predicate(MultiplicityConstraint.fromMax(minMax.getMax()));
        }
        return Optional.of(c);
    }

    private MinMaxBoundary getMinMaxForMultiplicity(PropertyDefinition pd) throws ValidationConfigurationException {
        Integer min = null;
        Integer max = null;
        for (String multi : pd.getMultiplicity()) {
            NumParamConstraint nC = new NumParamConstraint(multi);
            ValidationConstants.ValidationMethods method = nC.getAndAssertValidationMethod();
            if (method.equals((Object)ValidationConstants.ValidationMethods.MIN) && (min == null || min > nC.getNum())) {
                min = nC.getNum();
                continue;
            }
            if (method.equals((Object)ValidationConstants.ValidationMethods.MAX) && (max == null || max > nC.getNum())) {
                max = nC.getNum();
                continue;
            }
            if (method.equals((Object)ValidationConstants.ValidationMethods.FIXED)) {
                if (max == null || max > nC.getNum()) {
                    max = nC.getNum();
                }
                if (min != null && min <= nC.getNum()) continue;
                min = nC.getNum();
                continue;
            }
            throw new ValidationConfigurationException("Configured constraint method not implemented for multiplicity validation: " + nC.getMethod());
        }
        return new MinMaxBoundary(min, max);
    }

    public List<ValidationConfigurationException> getConfigurationExceptions() {
        return this.configurationExceptions;
    }

    public VocabularyLookupService getVocabularyLookupService() {
        return this.vocabularyLookupService;
    }

    public ValidationEntityService getEntityService() {
        return this.entityService;
    }

    public AutoqueryEntityLookupService getAutoqueryLookupService() {
        return this.autoqueryLookupService;
    }

    private class MinMaxBoundary {
        private final Integer min;
        private final Integer max;

        public MinMaxBoundary(Integer min, Integer max) {
            this.min = min;
            this.max = max;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MinMaxBoundary)) {
                return false;
            }
            MinMaxBoundary other = (MinMaxBoundary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$min = this.getMin();
            Integer other$min = other.getMin();
            if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                return false;
            }
            Integer this$max = this.getMax();
            Integer other$max = other.getMax();
            return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MinMaxBoundary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $min = this.getMin();
            result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
            Integer $max = this.getMax();
            result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
            return result;
        }

        public String toString() {
            return "PropertyValidator.MinMaxBoundary(min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }
    }
}

