/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.validation;

import de.uniba.minf.registry.model.validation.ValidationConstants;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumParamConstraint {
    private static final Pattern WITH_NUM_PARAM_PATTERN = Pattern.compile("([^\\(]+)(\\((\\d+)\\))?");
    private String method = null;
    private Integer num = null;

    public NumParamConstraint(String name) {
        Matcher matcher = WITH_NUM_PARAM_PATTERN.matcher(name);
        if (matcher.find()) {
            if (matcher.groupCount() > 0) {
                this.method = matcher.group(1);
            }
            if (matcher.groupCount() > 2) {
                this.num = matcher.group(3) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(3)));
            }
        }
    }

    public ValidationConstants.ValidationMethods getAndAssertValidationMethod() throws ValidationConfigurationException {
        for (ValidationConstants.ValidationMethods m : ValidationConstants.ValidationMethods.values()) {
            if (!this.methodEquals(m.name())) continue;
            if (m.getNumArgRequired()) {
                this.assertHasNum();
            }
            return m;
        }
        throw new ValidationConfigurationException("Configured constraint method unknown: " + this.method);
    }

    public boolean hasNum() {
        return this.num != null;
    }

    public double numAsDouble() {
        return this.num.doubleValue();
    }

    private boolean methodEquals(String methodIgnoreCase) throws ValidationConfigurationException {
        if (this.method == null) {
            throw new ValidationConfigurationException("Configured constraint method cannot be null");
        }
        return this.method.equalsIgnoreCase(methodIgnoreCase);
    }

    private boolean assertHasNum() throws ValidationConfigurationException {
        if (this.num == null) {
            throw new ValidationConfigurationException("Configured constraint requires numerical argument, such as " + (String)(this.method != null ? this.method + "(" : "method(") + "3)");
        }
        return true;
    }

    public String getMethod() {
        return this.method;
    }

    public Integer getNum() {
        return this.num;
    }
}

