/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization.base;

import de.uniba.minf.registry.model.serialization.base.SerializationError;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(SerializationMessage.class);
    private static final long serialVersionUID = -7281794978141314949L;
    private MESSAGE_TYPES type;
    private String message;

    public static SerializationMessage handleMessage(MESSAGE_TYPES type, String message, Object ... args) throws SerializationError {
        return SerializationMessage.handleMessage(type, String.format(message, args));
    }

    public static SerializationMessage handleMessage(MESSAGE_TYPES type, String message) throws SerializationError {
        SerializationMessage msg = new SerializationMessage(type, message);
        msg.handle();
        return msg;
    }

    public SerializationMessage(MESSAGE_TYPES type, String message) {
        this.type = type;
        this.message = message;
    }

    public void handle() throws SerializationError {
        if (this.type == MESSAGE_TYPES.NOTICE) {
            log.info(this.getMessage());
        } else if (this.type == MESSAGE_TYPES.WARN) {
            log.warn(this.getMessage());
        } else if (this.type == MESSAGE_TYPES.ERROR) {
            log.error(this.getMessage());
        } else {
            log.error(this.getMessage());
            throw new SerializationError(this.getMessage());
        }
    }

    public MESSAGE_TYPES getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setType(MESSAGE_TYPES type) {
        this.type = type;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializationMessage)) {
            return false;
        }
        SerializationMessage other = (SerializationMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MESSAGE_TYPES this$type = this.getType();
        MESSAGE_TYPES other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SerializationMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MESSAGE_TYPES $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "SerializationMessage(type=" + this.getType() + ", message=" + this.getMessage() + ")";
    }

    public static enum MESSAGE_TYPES {
        NOTICE,
        WARN,
        ERROR,
        FAIL;

    }
}

