/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization.base;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.uniba.minf.registry.model.BooleanPropertyValue;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinitionBlock;
import de.uniba.minf.registry.model.helper.PropertyDefinitionHelper;
import de.uniba.minf.registry.model.serialization.base.SerializationError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class BasePropertyListDeserializer<T extends PropertyList, U extends BaseDefinition>
extends StdDeserializer<T> {
    private static final long serialVersionUID = -6318915380659257038L;
    private static final String DIRECT_FIELD_PREFIX = "_";

    public BasePropertyListDeserializer(Class<?> c) {
        super(c);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        T obj = this.createObject(node);
        U def = this.getDefinition(obj);
        ((PropertyList)obj).setProperties(new ArrayList<Property>());
        try {
            ((PropertyList)obj).setProperties(this.deserializePropertyObject(node, def == null ? new ArrayList() : ((BaseDefinition)def).getAllProperties(), def == null ? null : ((BaseDefinition)def).getPropertyBlocks()).getProperties());
            this.finalizeObject(obj, node);
        }
        catch (SerializationError e) {
            throw new IOException("Failed to deserialize obj", e);
        }
        return obj;
    }

    protected abstract U getDefinition(T var1);

    protected abstract T createObject(JsonNode var1);

    protected void finalizeObject(T obj, JsonNode node) {
    }

    private Property deserializeProperty(String field, JsonNode node, PropertyDefinition def) throws SerializationError {
        String fieldName;
        ArrayList<PropertyDefinition> subDefs = def != null && HierarchicalPropertyDefinition.class.isAssignableFrom(def.getClass()) ? ((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(def)).getProperties() : new ArrayList<PropertyDefinition>(0);
        PropertyImpl prop = new PropertyImpl();
        String lang = null;
        if (field.contains("#")) {
            fieldName = field.substring(0, field.indexOf("#"));
            lang = field.substring(field.indexOf("#") + 1);
        } else {
            fieldName = field;
        }
        if (node.isArray() && !node.isEmpty()) {
            if (node.get(0).has("_value")) {
                for (JsonNode subNode : node) {
                    if (subNode.has("_value")) {
                        lang = subNode.has("_lang") ? subNode.get("_lang").asText(null) : null;
                        prop.addValue(this.getValue(subNode.get("_value"), def, lang));
                        continue;
                    }
                    prop.setProperties(new ArrayList<PropertyList>());
                    prop.getProperties().add(this.deserializePropertyObject(node, subDefs, null));
                }
            } else {
                prop.setValue(this.getValueList(node, def, lang));
                prop.setProperties(this.getPropertyObjectList(node, subDefs));
            }
        } else if (node.isValueNode()) {
            prop.setValue(this.getValue(node, def, lang));
        } else if (node.isObject() && !node.isEmpty()) {
            if (node.has("_value")) {
                lang = node.has("_lang") ? node.get("_lang").asText(null) : null;
                prop.setValue(this.getValue(node.get("_value"), def, lang));
            } else {
                prop.setProperties(new ArrayList<PropertyList>());
                prop.getProperties().add(this.deserializePropertyObject(node, subDefs, null));
            }
        } else {
            return null;
        }
        prop.setLabel(fieldName);
        return prop;
    }

    private List<PropertyList> getPropertyObjectList(JsonNode array, List<PropertyDefinition> defs) throws SerializationError {
        ArrayList<PropertyList> list = new ArrayList<PropertyList>();
        for (JsonNode node : array) {
            if (!node.isObject()) continue;
            list.add(this.deserializePropertyObject(node, defs, null));
        }
        return list.isEmpty() ? null : list;
    }

    private PropertyList deserializePropertyObject(JsonNode node, List<PropertyDefinition> defs, List<PropertyDefinitionBlock> blocks) throws SerializationError {
        PropertyList properties = new PropertyList();
        Iterator fieldIterator = node.fields();
        while (fieldIterator.hasNext()) {
            Optional<PropertyDefinitionBlock> bl;
            Map.Entry fieldEntry = (Map.Entry)fieldIterator.next();
            if (((String)fieldEntry.getKey()).startsWith(DIRECT_FIELD_PREFIX)) continue;
            Optional<PropertyDefinition> def = defs.stream().filter(d -> d.getName().equals(fieldEntry.getKey())).findFirst();
            if (def.isEmpty() && blocks != null && (bl = blocks.stream().filter(b -> b.getName() != null && b.getName().equals(fieldEntry.getKey())).findFirst()).isPresent()) {
                if (((JsonNode)fieldEntry.getValue()).isArray()) {
                    List<PropertyList> pls = this.getPropertyObjectList((JsonNode)fieldEntry.getValue(), bl.get().getProperties());
                    if (pls == null || pls.isEmpty()) continue;
                    for (PropertyList pl : pls) {
                        if (pl.getProperties() == null || pl.getProperties().isEmpty()) continue;
                        properties.addAll(pl.getProperties());
                    }
                    continue;
                }
                PropertyList pl = this.deserializePropertyObject((JsonNode)fieldEntry.getValue(), bl.get().getProperties(), null);
                if (pl.getProperties() == null || pl.getProperties().isEmpty()) continue;
                properties.addAll(pl.getProperties());
                continue;
            }
            Property property = this.deserializeProperty((String)fieldEntry.getKey(), (JsonNode)fieldEntry.getValue(), def.orElse(null));
            if (property == null) continue;
            properties.add(property);
        }
        return properties;
    }

    private PropertyValue getValue(JsonNode node, PropertyDefinition def, String lang) {
        if (def == null) {
            if (node.isDouble()) {
                return new DoublePropertyValue(node.asDouble(), lang);
            }
            if (node.isBoolean()) {
                return new BooleanPropertyValue(node.asBoolean(), lang);
            }
            if (node.canConvertToInt()) {
                return new IntegerPropertyValue(node.asInt(), lang);
            }
            if (node.asText().length() > 5 && node.asText().charAt(3) == '#') {
                return new TextPropertyValue(node.asText().substring(4), node.asText().substring(0, 3));
            }
            return new TextPropertyValue(node.asText());
        }
        return PropertyDefinitionHelper.transformJsonTree(def, node, lang);
    }

    private PropertyValueList getValueList(JsonNode array, PropertyDefinition def, String lang) {
        PropertyValueList list = new PropertyValueList();
        for (JsonNode node : array) {
            if (!node.isValueNode()) continue;
            list.add(this.getValue(node, def, lang));
        }
        return list.isEmpty() ? null : list;
    }
}

