/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization.base;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.uniba.minf.registry.model.definition.AutofillPropertyDefinition;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinitionBlock;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import java.io.IOException;
import java.util.List;

public abstract class BaseDefinitionSerializer<T extends BaseDefinition>
extends StdSerializer<T> {
    private static final long serialVersionUID = 4058774142036126961L;

    protected BaseDefinitionSerializer(Class<T> vc) {
        super(vc);
    }

    public void serialize(T d, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.writeStringField("name", ((BaseDefinition)d).getLabel(), gen);
        this.writeTrueField("system", ((BaseDefinition)d).isSystem(), gen);
        this.writeMessageCode(((BaseDefinition)d).getMessageCode(), ((BaseDefinition)d).getName(), ((BaseDefinition)d).getName(), gen);
        if (((BaseDefinition)d).getEndpointUrl() != null || ((BaseDefinition)d).getEndpointMethod() != null) {
            gen.writeObjectFieldStart("endpoint");
            this.writeStringField("url", ((BaseDefinition)d).getEndpointUrl(), gen);
            this.writeStringField("method", ((BaseDefinition)d).getEndpointMethod(), gen);
            gen.writeEndObject();
        }
        if (((BaseDefinition)d).getPreviewPropertyIdentifiers() != null && !((BaseDefinition)d).getPreviewPropertyIdentifiers().isEmpty()) {
            gen.writeArrayFieldStart("preview_properties");
            for (String string : ((BaseDefinition)d).getPreviewPropertyIdentifiers()) {
                gen.writeString(string.substring(((BaseDefinition)d).getName().length() + 1));
            }
            gen.writeEndArray();
        }
        if (((BaseDefinition)d).getPropertyBlocks() != null) {
            if (((BaseDefinition)d).getPropertyBlocks().size() == 1 && ((BaseDefinition)d).getPropertyBlocks().get(0).getName() == null) {
                this.serializeProperties(((BaseDefinition)d).getPropertyBlocks().get(0).getProperties(), gen, provider);
            } else {
                gen.writeArrayFieldStart("blocks");
                for (PropertyDefinitionBlock propertyDefinitionBlock : ((BaseDefinition)d).getPropertyBlocks()) {
                    gen.writeStartObject();
                    this.serializePropertyBlock(propertyDefinitionBlock, gen, provider);
                    gen.writeEndObject();
                }
                gen.writeEndArray();
            }
        }
    }

    private void serializePropertyBlock(PropertyDefinitionBlock b, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.writeStringField("name", b.getName(), gen);
        this.writeMessageCode(b.getMessageCode(), b.getName(), b.getIdentifier(), gen);
        this.serializeProperties(b.getProperties(), gen, provider);
    }

    private void serializeProperties(List<PropertyDefinition> pds, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (pds == null || pds.isEmpty()) {
            return;
        }
        gen.writeArrayFieldStart("properties");
        for (PropertyDefinition pd : pds) {
            gen.writeStartObject();
            this.serializePropertyDefinition(pd, gen, provider);
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void serializeVocabularyPropertyDefinition(VocabularyPropertyDefinition vpd, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (vpd.isEntity()) {
            this.writeStringField("entity", vpd.getVocabulary(), gen);
            this.writeStringField("relation_type", vpd.getEntityRelationType(), gen);
            this.writeStringField("relation_vocabulary", vpd.getEntityRelationVocabulary(), gen);
        } else {
            this.writeStringField("vocabulary", vpd.getVocabulary(), gen);
        }
        this.writeTrueField("strict", vpd.isStrict(), gen);
        this.writeTrueField("query", vpd.isQuery(), gen);
        this.writeTrueField("autoquery", vpd.isAutoQuery(), gen);
        this.writeStringField("default", vpd.getDefaultEntry(), gen);
        if (vpd.isAutofillAll()) {
            gen.writeBooleanField("autofill", true);
        } else if (vpd.isAutofill()) {
            gen.writeArrayFieldStart("autofill");
            for (AutofillPropertyDefinition afPd : vpd.getAutofillProperties()) {
                if (afPd.getExternalName() != null) {
                    gen.writeString(afPd.getPropertyName() + "=" + afPd.getExternalName());
                    continue;
                }
                gen.writeString(afPd.getPropertyName());
            }
            gen.writeEndArray();
        }
    }

    private void serializePropertyDefinition(PropertyDefinition pd, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStringField("field", pd.getName());
        this.writeMessageCode(pd.getMessageCode(), pd.getName(), pd.getIdentifier(), gen);
        if (pd.isVocabulary()) {
            this.serializeVocabularyPropertyDefinition((VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(pd), gen, provider);
        } else if (pd.isSimple()) {
            this.writeStringField("type", ((SimplePropertyDefinition)SimplePropertyDefinition.class.cast(pd)).getType().name().toLowerCase(), gen);
        }
        if (pd.getMandatoryGroup() != null) {
            this.writeStringField("mandatory", pd.getMandatoryGroup(), gen);
        } else {
            this.writeTrueField("mandatory", pd.isMandatory(), gen);
        }
        this.writeTrueField("identifier", pd.isExternalIdentifier(), gen);
        if (pd.getMultiplicity() != null && !pd.getMultiplicity().isEmpty()) {
            this.writeStringArgs("multiple", pd.getMultiplicity(), gen);
        }
        if (pd.getMultilang() != null && !pd.getMultilang().isEmpty()) {
            this.writeStringArgs("multilang", pd.getMultilang(), gen);
        }
        if (pd.getValid() != null && !pd.getValid().isEmpty()) {
            this.writeStringArgs("valid", pd.getValid(), gen);
        }
        if (pd.isHierarchical()) {
            this.serializeProperties(((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(pd)).getProperties(), gen, provider);
        }
    }

    protected void writeStringArgs(String field, List<String> args, JsonGenerator gen) throws IOException {
        if (args.size() == 1) {
            this.writeStringAsStringOrBooleanField(field, args.get(0), gen);
        } else {
            gen.writeArrayFieldStart(field);
            for (String v : args) {
                this.writeStringAsStringOrBoolean(v, gen);
            }
            gen.writeEndArray();
        }
    }

    protected void writeStringAsStringOrBoolean(String value, JsonGenerator gen) throws IOException {
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
            gen.writeBoolean(value.toLowerCase().equals("true"));
        } else {
            gen.writeString(value);
        }
    }

    protected void writeStringAsStringOrBooleanField(String field, String value, JsonGenerator gen) throws IOException {
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
            gen.writeBooleanField(field, value.toLowerCase().equals("true"));
        } else {
            gen.writeStringField(field, value);
        }
    }

    protected void writeTrueField(String field, boolean value, JsonGenerator gen) throws IOException {
        if (value) {
            gen.writeBooleanField(field, value);
        }
    }

    protected void writeStringField(String field, String value, JsonGenerator gen) throws IOException {
        if (value != null) {
            gen.writeStringField(field, value);
        }
    }

    protected void writeMessageCode(String code, String label, String identifier, JsonGenerator gen) throws IOException {
        if (!code.equals("~" + label) && !code.equals("~" + identifier)) {
            gen.writeStringField("code", code);
        }
    }
}

