/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.loaders.VocabularyDefinitionLoader;
import de.uniba.minf.registry.model.serialization.base.BasePropertyListDeserializer;
import de.uniba.minf.registry.model.vocabulary.Reference;
import de.uniba.minf.registry.model.vocabulary.ValueVariant;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;

public class VocabularyEntryDeserializer
extends BasePropertyListDeserializer<VocabularyEntry, VocabularyDefinition> {
    private static final long serialVersionUID = -528374543878482810L;
    private static final String VOCABULARY_FIELD = "_vocabulary";
    @Autowired
    private VocabularyDefinitionLoader vocabularyDefinitionLoader;

    public VocabularyEntryDeserializer() {
        this(null);
    }

    public VocabularyEntryDeserializer(Class<?> c) {
        super(c);
    }

    @Override
    protected VocabularyEntry createObject(JsonNode node) {
        VocabularyEntry vocabulary = new VocabularyEntry();
        if (node.has(VOCABULARY_FIELD)) {
            vocabulary.setDefinitionName(node.get(VOCABULARY_FIELD).asText());
        }
        return vocabulary;
    }

    @Override
    protected VocabularyDefinition getDefinition(VocabularyEntry obj) {
        return this.vocabularyDefinitionLoader.findCurrentByName(obj.getDefinitionName());
    }

    @Override
    protected void finalizeObject(VocabularyEntry obj, JsonNode node) {
        obj.setKey(this.getAsTextOrNull(obj, "key"));
        String primaryValue = this.getAsTextOrNull(obj, "primaryValue");
        if (primaryValue == null) {
            primaryValue = this.getAsTextOrNull(obj, "value");
        }
        if (node.has("score")) {
            obj.setScore(node.get("score").asDouble());
        }
        obj.setPrimaryValue(primaryValue);
        Property p = obj.get("localizedValue");
        if (p != null && p.getProperties() != null) {
            p.getProperties().stream().forEach(prop -> {
                String locale = this.getAsTextOrNull((PropertyList)prop, "lang");
                String value = this.getAsTextOrNull((PropertyList)prop, "value");
                if (obj.getPrimaryValue() == null && value != null) {
                    obj.setPrimaryValue(value);
                }
                if (value != null) {
                    if (obj.getVariants() == null) {
                        obj.setVariants(new ArrayList<ValueVariant>());
                    }
                    ValueVariant variant = new ValueVariant();
                    variant.setLang(locale);
                    variant.setValue(value);
                    obj.getVariants().add(variant);
                }
            });
        }
        if ((p = obj.get("reference")) != null && p.getProperties() != null) {
            p.getProperties().stream().forEach(prop -> {
                String namespace = this.getAsTextOrNull((PropertyList)prop, "namespace");
                String value = this.getAsTextOrNull((PropertyList)prop, "value");
                if (value != null) {
                    if (obj.getReferences() == null) {
                        obj.setReferences(new ArrayList<Reference>());
                    }
                    Reference ref = new Reference();
                    ref.setNamespace(namespace);
                    ref.setValue(value);
                    obj.getReferences().add(ref);
                }
            });
        }
    }

    private String getAsTextOrNull(PropertyList list, String property) {
        Property p = list.get(property);
        if (p != null && p.getValue() != null) {
            return p.getValue().asText();
        }
        return null;
    }
}

