/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerializer
extends StdSerializer<Entity> {
    private static final Logger log = LoggerFactory.getLogger(EntitySerializer.class);
    private static final long serialVersionUID = -6917667738353884153L;

    public EntitySerializer() {
        this(null);
    }

    public EntitySerializer(Class<Entity> c) {
        super(c);
    }

    public void serialize(Entity e, JsonGenerator gen, SerializerProvider provider) throws IOException {
        log.debug("there");
        gen.writeStartObject();
        gen.writeStringField("_entity", e.getDefinitionName());
        gen.writeNumberField("_entity_version", e.getDefinitionVersion());
        this.serializeProperties(gen, e.getProperties());
        gen.writeEndObject();
    }

    private void serializeProperties(JsonGenerator gen, List<Property> properties) throws IOException {
        for (Property p : properties) {
            if (p.getProperties() != null && !p.getProperties().isEmpty()) {
                gen.writeFieldName(p.getLabel());
                gen.writeStartArray();
                this.serializePropertyList(gen, p.getProperties());
                gen.writeEndArray();
                continue;
            }
            HashMap fieldNameValuesMap = new HashMap();
            List<PropertyValue> propertyValues = p.valuesAsList();
            if (propertyValues == null || propertyValues.isEmpty()) continue;
            for (PropertyValue propertyValue : propertyValues) {
                Object fieldName = p.getLabel();
                if (propertyValue.getLang() != null && !propertyValue.getLang().isEmpty()) {
                    fieldName = (String)fieldName + "#" + propertyValue.getLang();
                }
                if (!fieldNameValuesMap.containsKey(fieldName)) {
                    fieldNameValuesMap.put((String)fieldName, new ArrayList());
                }
                ((List)fieldNameValuesMap.get(fieldName)).add(propertyValue);
            }
            for (Map.Entry entry : fieldNameValuesMap.entrySet()) {
                if (((List)entry.getValue()).size() == 1) {
                    if (((List)entry.getValue()).get(0) == null) continue;
                    if (p.getDefinition().isSimple() && p.getDefinition().asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN)) {
                        gen.writeBooleanField((String)entry.getKey(), ((PropertyValue)((List)entry.getValue()).get(0)).asBoolean());
                        continue;
                    }
                    if (p.getDefinition().isSimple() && p.getDefinition().asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.FLOAT)) {
                        gen.writeNumberField((String)entry.getKey(), ((Double)((DoublePropertyValue)DoublePropertyValue.class.cast(((List)entry.getValue()).get(0))).getValue()).doubleValue());
                        continue;
                    }
                    if (p.getDefinition().isSimple() && p.getDefinition().asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.INT)) {
                        gen.writeNumberField((String)entry.getKey(), ((Integer)((IntegerPropertyValue)IntegerPropertyValue.class.cast(((List)entry.getValue()).get(0))).getValue()).intValue());
                        continue;
                    }
                    gen.writeStringField((String)entry.getKey(), ((PropertyValue)((List)entry.getValue()).get(0)).asText());
                    continue;
                }
                gen.writeFieldName((String)entry.getKey());
                gen.writeStartArray();
                for (PropertyValue pv : (List)entry.getValue()) {
                    if (pv == null) continue;
                    if (p.getDefinition().isSimple() && p.getDefinition().asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN)) {
                        gen.writeBoolean(pv.asBoolean());
                        continue;
                    }
                    if (p.getDefinition().isSimple() && p.getDefinition().asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.FLOAT)) {
                        gen.writeNumber(((Double)((DoublePropertyValue)DoublePropertyValue.class.cast(pv)).getValue()).doubleValue());
                        continue;
                    }
                    if (p.getDefinition().isSimple() && p.getDefinition().asSimple().getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.INT)) {
                        gen.writeNumber(((Integer)((IntegerPropertyValue)IntegerPropertyValue.class.cast(pv)).getValue()).intValue());
                        continue;
                    }
                    gen.writeString(pv.asText());
                }
                gen.writeEndArray();
            }
        }
    }

    private void serializePropertyList(JsonGenerator gen, List<PropertyList> properties) throws IOException {
        gen.writeStartObject();
        for (PropertyList pl : properties) {
            this.serializeProperties(gen, pl.getProperties());
        }
        gen.writeEndObject();
    }
}

