/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.loaders.EntityDefinitionLoader;
import de.uniba.minf.registry.model.serialization.base.BasePropertyListDeserializer;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityDeserializer
extends BasePropertyListDeserializer<Entity, EntityDefinition> {
    private static final long serialVersionUID = 5519790693725478035L;
    public static final String ENTITY_FIELD = "_entity";
    public static final String ENTITY_VERSION_FIELD = "_entity_version";
    @Autowired
    private EntityDefinitionLoader entityDefinitionLoader;

    public EntityDeserializer() {
        this(null);
    }

    public EntityDeserializer(Class<?> c) {
        super(c);
    }

    @Override
    protected Entity createObject(JsonNode node) {
        Entity entity = new Entity();
        if (node.has(ENTITY_FIELD)) {
            entity.setDefinitionName(node.get(ENTITY_FIELD).asText());
        }
        if (node.has(ENTITY_VERSION_FIELD)) {
            entity.setDefinitionVersion(node.get(ENTITY_VERSION_FIELD).asLong());
        }
        return entity;
    }

    @Override
    protected EntityDefinition getDefinition(Entity entity) {
        return this.entityDefinitionLoader.findCurrentByName(entity.getDefinitionName());
    }
}

