/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.serialization.base.BaseDefinitionSerializer;
import java.io.IOException;
import java.util.Map;

public class EntityDefinitionSerializer
extends BaseDefinitionSerializer<EntityDefinition> {
    private static final long serialVersionUID = -4479783538703957404L;

    public EntityDefinitionSerializer() {
        this((Class<EntityDefinition>)null);
    }

    public EntityDefinitionSerializer(Class<EntityDefinition> c) {
        super(c);
    }

    @Override
    public void serialize(EntityDefinition value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("entity", value.getName());
        this.writeTrueField("primary", value.isPrimary(), gen);
        if (value.getPresentationProperties() != null && !value.getPresentationProperties().isEmpty()) {
            gen.writeObjectFieldStart("presentation");
            for (Map.Entry<String, String> e : value.getPresentationProperties().entrySet()) {
                this.writeStringField(e.getKey(), e.getValue(), gen);
            }
            gen.writeEndObject();
        }
        super.serialize(value, gen, provider);
        gen.writeEndObject();
    }
}

