/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.serialization.base.BaseDefinitionDeserializer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EntityDefinitionDeserializer
extends BaseDefinitionDeserializer<EntityDefinition> {
    private static final long serialVersionUID = 5519790693725478035L;

    public EntityDefinitionDeserializer() {
        this(null);
    }

    public EntityDefinitionDeserializer(Class<?> c) {
        super(c);
    }

    @Override
    protected EntityDefinition createDefinition(JsonNode node) {
        EntityDefinition def = new EntityDefinition();
        def.setName(node.get("entity").asText());
        def.setPrimary(node.has("primary") && node.get("primary").asBoolean());
        if (node.has("presentation") && node.get("presentation").isObject()) {
            def.setPresentationProperties(new HashMap<String, String>());
            Iterator fieldIterator = node.get("presentation").fields();
            while (fieldIterator.hasNext()) {
                Map.Entry presentationProperty = (Map.Entry)fieldIterator.next();
                if (!((JsonNode)presentationProperty.getValue()).isValueNode() || ((JsonNode)presentationProperty.getValue()).isNull()) continue;
                def.getPresentationProperties().put((String)presentationProperty.getKey(), ((JsonNode)presentationProperty.getValue()).asText());
            }
        }
        return def;
    }
}

