/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.uniba.minf.registry.model.BooleanPropertyValue;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;

public class PropertyDefinitionHelper {
    private PropertyDefinitionHelper() {
    }

    public static PropertyValue transformJsonTree(PropertyDefinition definition, JsonNode node, String lang) {
        if (definition == null || !definition.isSimple()) {
            return new TextPropertyValue(node.asText());
        }
        String nodeAsText = node.asText();
        if (nodeAsText.length() > 4 && nodeAsText.charAt(3) == '#') {
            lang = nodeAsText.substring(0, 3);
            node = TextNode.valueOf((String)nodeAsText.substring(4));
        }
        SimplePropertyDefinition spd = (SimplePropertyDefinition)SimplePropertyDefinition.class.cast(definition);
        if (node.isArray()) {
            PropertyValueList result = new PropertyValueList();
            for (JsonNode n : node) {
                result.add(PropertyDefinitionHelper.transformJsonTree(definition, n, lang));
            }
            return result;
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN) && !node.isBoolean()) {
            return new BooleanPropertyValue(nodeAsText.equalsIgnoreCase("true") || nodeAsText.equalsIgnoreCase("1"), lang);
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.FLOAT) && !node.isDouble() && !node.isFloat()) {
            try {
                return new DoublePropertyValue(Double.parseDouble(nodeAsText), lang);
            }
            catch (NumberFormatException e) {
                return new DoublePropertyValue(node.asDouble(), lang);
            }
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.INT) && !node.isLong() && !node.isInt()) {
            try {
                return new IntegerPropertyValue(Integer.parseInt(nodeAsText), lang);
            }
            catch (NumberFormatException e) {
                return new IntegerPropertyValue(node.asInt(), lang);
            }
        }
        return new TextPropertyValue(nodeAsText, lang);
    }

    public static PropertyValue transformIfRequiredAndPossible(PropertyDefinition definition, PropertyValue value) {
        if (value == null || definition == null || !definition.isSimple()) {
            return value;
        }
        SimplePropertyDefinition spd = (SimplePropertyDefinition)SimplePropertyDefinition.class.cast(definition);
        if (PropertyValueList.class.isAssignableFrom(value.getClass())) {
            PropertyValueList result = new PropertyValueList();
            for (PropertyValue v : ((PropertyValueList)PropertyValueList.class.cast(value)).getValues()) {
                result.add(PropertyDefinitionHelper.transformIfRequiredAndPossible(definition, v));
            }
            return result;
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN) && !BooleanPropertyValue.class.isAssignableFrom(value.getClass())) {
            return new BooleanPropertyValue(value.asText().equalsIgnoreCase("true") || value.asText().equalsIgnoreCase("1"), value.getLang());
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.FLOAT) && !DoublePropertyValue.class.isAssignableFrom(value.getClass())) {
            try {
                return new DoublePropertyValue(Double.parseDouble(value.asText()), value.getLang());
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.INT) && !IntegerPropertyValue.class.isAssignableFrom(value.getClass())) {
            try {
                return new IntegerPropertyValue(Integer.parseInt(value.asText()), value.getLang());
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }
}

