/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.entity;

import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.entity.Entity;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Instant;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class EntityRelation
extends PropertyList
implements Serializable {
    private static final long serialVersionUID = -4698722200982783667L;
    @Id
    private String uniqueId;
    @Indexed
    @NotNull
    private String fromUniqueId;
    @Indexed
    @NotNull
    private String toUniqueId;
    @Indexed
    @NotNull
    private String fromEntityId;
    @Indexed
    @NotNull
    private String toEntityId;
    private String fromPath;
    private String toPath;
    private MainRelationTypes mainRelationType;
    private String typeVocabulary;
    private String typeVocabularyKey;
    private Instant creationInstant;
    private String userUniqueId;

    public boolean isInverseForEntity(Entity e) {
        return !this.getFromUniqueId().equals(e.getUniqueId());
    }

    public String getRelatedUniqueIdForEntity(Entity e) {
        return this.isInverseForEntity(e) ? this.getFromUniqueId() : this.getToUniqueId();
    }

    public String getPathForEntity(Entity e) {
        return !this.isInverseForEntity(e) ? this.getFromPath() : this.getToPath();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getFromUniqueId() {
        return this.fromUniqueId;
    }

    public String getToUniqueId() {
        return this.toUniqueId;
    }

    public String getFromEntityId() {
        return this.fromEntityId;
    }

    public String getToEntityId() {
        return this.toEntityId;
    }

    public String getFromPath() {
        return this.fromPath;
    }

    public String getToPath() {
        return this.toPath;
    }

    public MainRelationTypes getMainRelationType() {
        return this.mainRelationType;
    }

    public String getTypeVocabulary() {
        return this.typeVocabulary;
    }

    public String getTypeVocabularyKey() {
        return this.typeVocabularyKey;
    }

    public Instant getCreationInstant() {
        return this.creationInstant;
    }

    public String getUserUniqueId() {
        return this.userUniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setFromUniqueId(String fromUniqueId) {
        this.fromUniqueId = fromUniqueId;
    }

    public void setToUniqueId(String toUniqueId) {
        this.toUniqueId = toUniqueId;
    }

    public void setFromEntityId(String fromEntityId) {
        this.fromEntityId = fromEntityId;
    }

    public void setToEntityId(String toEntityId) {
        this.toEntityId = toEntityId;
    }

    public void setFromPath(String fromPath) {
        this.fromPath = fromPath;
    }

    public void setToPath(String toPath) {
        this.toPath = toPath;
    }

    public void setMainRelationType(MainRelationTypes mainRelationType) {
        this.mainRelationType = mainRelationType;
    }

    public void setTypeVocabulary(String typeVocabulary) {
        this.typeVocabulary = typeVocabulary;
    }

    public void setTypeVocabularyKey(String typeVocabularyKey) {
        this.typeVocabularyKey = typeVocabularyKey;
    }

    public void setCreationInstant(Instant creationInstant) {
        this.creationInstant = creationInstant;
    }

    public void setUserUniqueId(String userUniqueId) {
        this.userUniqueId = userUniqueId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityRelation)) {
            return false;
        }
        EntityRelation other = (EntityRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$fromUniqueId = this.getFromUniqueId();
        String other$fromUniqueId = other.getFromUniqueId();
        if (this$fromUniqueId == null ? other$fromUniqueId != null : !this$fromUniqueId.equals(other$fromUniqueId)) {
            return false;
        }
        String this$toUniqueId = this.getToUniqueId();
        String other$toUniqueId = other.getToUniqueId();
        if (this$toUniqueId == null ? other$toUniqueId != null : !this$toUniqueId.equals(other$toUniqueId)) {
            return false;
        }
        String this$fromEntityId = this.getFromEntityId();
        String other$fromEntityId = other.getFromEntityId();
        if (this$fromEntityId == null ? other$fromEntityId != null : !this$fromEntityId.equals(other$fromEntityId)) {
            return false;
        }
        String this$toEntityId = this.getToEntityId();
        String other$toEntityId = other.getToEntityId();
        if (this$toEntityId == null ? other$toEntityId != null : !this$toEntityId.equals(other$toEntityId)) {
            return false;
        }
        String this$fromPath = this.getFromPath();
        String other$fromPath = other.getFromPath();
        if (this$fromPath == null ? other$fromPath != null : !this$fromPath.equals(other$fromPath)) {
            return false;
        }
        String this$toPath = this.getToPath();
        String other$toPath = other.getToPath();
        if (this$toPath == null ? other$toPath != null : !this$toPath.equals(other$toPath)) {
            return false;
        }
        MainRelationTypes this$mainRelationType = this.getMainRelationType();
        MainRelationTypes other$mainRelationType = other.getMainRelationType();
        if (this$mainRelationType == null ? other$mainRelationType != null : !((Object)((Object)this$mainRelationType)).equals((Object)other$mainRelationType)) {
            return false;
        }
        String this$typeVocabulary = this.getTypeVocabulary();
        String other$typeVocabulary = other.getTypeVocabulary();
        if (this$typeVocabulary == null ? other$typeVocabulary != null : !this$typeVocabulary.equals(other$typeVocabulary)) {
            return false;
        }
        String this$typeVocabularyKey = this.getTypeVocabularyKey();
        String other$typeVocabularyKey = other.getTypeVocabularyKey();
        if (this$typeVocabularyKey == null ? other$typeVocabularyKey != null : !this$typeVocabularyKey.equals(other$typeVocabularyKey)) {
            return false;
        }
        Instant this$creationInstant = this.getCreationInstant();
        Instant other$creationInstant = other.getCreationInstant();
        if (this$creationInstant == null ? other$creationInstant != null : !((Object)this$creationInstant).equals(other$creationInstant)) {
            return false;
        }
        String this$userUniqueId = this.getUserUniqueId();
        String other$userUniqueId = other.getUserUniqueId();
        return !(this$userUniqueId == null ? other$userUniqueId != null : !this$userUniqueId.equals(other$userUniqueId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EntityRelation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $fromUniqueId = this.getFromUniqueId();
        result = result * 59 + ($fromUniqueId == null ? 43 : $fromUniqueId.hashCode());
        String $toUniqueId = this.getToUniqueId();
        result = result * 59 + ($toUniqueId == null ? 43 : $toUniqueId.hashCode());
        String $fromEntityId = this.getFromEntityId();
        result = result * 59 + ($fromEntityId == null ? 43 : $fromEntityId.hashCode());
        String $toEntityId = this.getToEntityId();
        result = result * 59 + ($toEntityId == null ? 43 : $toEntityId.hashCode());
        String $fromPath = this.getFromPath();
        result = result * 59 + ($fromPath == null ? 43 : $fromPath.hashCode());
        String $toPath = this.getToPath();
        result = result * 59 + ($toPath == null ? 43 : $toPath.hashCode());
        MainRelationTypes $mainRelationType = this.getMainRelationType();
        result = result * 59 + ($mainRelationType == null ? 43 : ((Object)((Object)$mainRelationType)).hashCode());
        String $typeVocabulary = this.getTypeVocabulary();
        result = result * 59 + ($typeVocabulary == null ? 43 : $typeVocabulary.hashCode());
        String $typeVocabularyKey = this.getTypeVocabularyKey();
        result = result * 59 + ($typeVocabularyKey == null ? 43 : $typeVocabularyKey.hashCode());
        Instant $creationInstant = this.getCreationInstant();
        result = result * 59 + ($creationInstant == null ? 43 : ((Object)$creationInstant).hashCode());
        String $userUniqueId = this.getUserUniqueId();
        result = result * 59 + ($userUniqueId == null ? 43 : $userUniqueId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EntityRelation(super=" + super.toString() + ", uniqueId=" + this.getUniqueId() + ", fromUniqueId=" + this.getFromUniqueId() + ", toUniqueId=" + this.getToUniqueId() + ", fromEntityId=" + this.getFromEntityId() + ", toEntityId=" + this.getToEntityId() + ", fromPath=" + this.getFromPath() + ", toPath=" + this.getToPath() + ", mainRelationType=" + this.getMainRelationType() + ", typeVocabulary=" + this.getTypeVocabulary() + ", typeVocabularyKey=" + this.getTypeVocabularyKey() + ", creationInstant=" + this.getCreationInstant() + ", userUniqueId=" + this.getUserUniqueId() + ")";
    }

    public static enum MainRelationTypes {
        SELF,
        CHILD,
        CUSTOM;

    }
}

