/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.definition;

import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinitionBlock;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.serialization.base.SerializationMessage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.Indexed;

@CompoundIndex(def="{'name': 1, 'version': 1}", unique=true)
public abstract class BaseDefinition
implements Identifiable {
    private static final Logger log = LoggerFactory.getLogger(BaseDefinition.class);
    private static final long serialVersionUID = 4908093821116664728L;
    @Id
    private String uniqueId;
    @Indexed
    private String name;
    private long version;
    private Instant creationInstant;
    private String userUniqueId;
    private String label;
    private String messageCode;
    private String endpointUrl;
    private String endpointMethod;
    @Indexed
    private String nextVersionUniqueId;
    private boolean system;
    private List<SerializationMessage> messages;
    private List<PropertyDefinitionBlock> propertyBlocks;
    private List<String> previewPropertyIdentifiers;

    public boolean isRemote() {
        return this.endpointUrl != null;
    }

    public String getMessageCode() {
        return this.messageCode != null ? this.messageCode : "~" + this.name;
    }

    public List<PropertyDefinition> getPreviewProperties() {
        ArrayList<PropertyDefinition> previewProperties = new ArrayList<PropertyDefinition>();
        if (this.previewPropertyIdentifiers != null && !this.previewPropertyIdentifiers.isEmpty()) {
            for (String previewPropertyIdentifier : this.previewPropertyIdentifiers) {
                Optional<PropertyDefinition> prevPd = this.getAllProperties().stream().filter(p -> p.getIdentifier().equals(previewPropertyIdentifier)).findFirst();
                if (prevPd.isPresent()) {
                    previewProperties.add(prevPd.get());
                    continue;
                }
                log.warn("Skipping unknown preview property identifier: " + previewPropertyIdentifier);
            }
        }
        if (previewProperties.size() < 5) {
            previewProperties.addAll(this.getAllProperties().stream().limit(5 - previewProperties.size()).toList());
        }
        return previewProperties;
    }

    public List<PropertyDefinition> getOrderedProperties() {
        ArrayList<PropertyDefinition> orderedProperties = new ArrayList<PropertyDefinition>();
        orderedProperties.addAll(this.getPreviewProperties());
        orderedProperties.addAll(this.getAllProperties().stream().filter(p -> !orderedProperties.contains(p) && !p.isSystem() && (p.isSimple() || p.isVocabulary())).toList());
        return orderedProperties;
    }

    public void addMessage(SerializationMessage message) {
        if (this.messages == null) {
            this.messages = new ArrayList<SerializationMessage>();
        }
        this.messages.add(message);
    }

    public PropertyDefinition getDefinition(String identifier) {
        String[] path = identifier.split("\\.");
        return BaseDefinition.getDefinition(this.getAllProperties(), path);
    }

    public PropertyDefinition getDefinition(String ... path) {
        return BaseDefinition.getDefinition(this.getAllProperties(), path);
    }

    public boolean hasAutoqueryProperties() {
        return !this.getAutoqueryProperties().isEmpty();
    }

    public boolean hasAutofillProperties() {
        return !this.getAutofillProperties().isEmpty();
    }

    public List<PropertyDefinition> getAllProperties() {
        return this.propertyBlocks.stream().flatMap(b -> b.getProperties().stream()).toList();
    }

    public List<VocabularyPropertyDefinition> getAutoqueryProperties() {
        return this.getProperties(this.getAllProperties(), PROPERTY_FLAGS.AUTOQUERY);
    }

    public List<VocabularyPropertyDefinition> getAutofillProperties() {
        return this.getProperties(this.getAllProperties(), PROPERTY_FLAGS.AUTOFILL);
    }

    public List<VocabularyPropertyDefinition> getEntityVocabularyProperties() {
        return this.getProperties(this.getAllProperties(), PROPERTY_FLAGS.ENTITY_VOCABULARY);
    }

    public List<PropertyDefinition> getExternalIdentifierProperties() {
        return this.getProperties(this.getAllProperties(), PROPERTY_FLAGS.EXTERNAL_IDENTIFIER);
    }

    private <T extends PropertyDefinition> List<T> getProperties(List<PropertyDefinition> properties, PROPERTY_FLAGS ... flags) {
        ArrayList<Object> matchingDefinitions = new ArrayList<Object>();
        for (PropertyDefinition pd : properties) {
            if (pd.isHierarchical()) {
                matchingDefinitions.addAll(this.getProperties(((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(pd)).getProperties(), flags));
                continue;
            }
            if (!this.getPropertyIsMatch(pd, flags)) continue;
            matchingDefinitions.add(pd);
        }
        return matchingDefinitions;
    }

    private boolean getPropertyIsMatch(PropertyDefinition pd, PROPERTY_FLAGS ... flags) {
        for (PROPERTY_FLAGS flag : flags) {
            if ((!flag.equals((Object)PROPERTY_FLAGS.AUTOQUERY) || pd.isVocabulary() && ((VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(pd)).isAutoQuery()) && (!flag.equals((Object)PROPERTY_FLAGS.AUTOFILL) || pd.isVocabulary() && ((VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(pd)).isAutofill()) && (!flag.equals((Object)PROPERTY_FLAGS.ENTITY_VOCABULARY) || pd.isVocabulary() && ((VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(pd)).isEntity()) && (!flag.equals((Object)PROPERTY_FLAGS.EXTERNAL_IDENTIFIER) || pd.isExternalIdentifier())) continue;
            return false;
        }
        return true;
    }

    private static PropertyDefinition getDefinition(List<PropertyDefinition> properties, String[] path) {
        if (properties != null) {
            for (PropertyDefinition def : properties) {
                if (!def.getName().equals(path[0])) continue;
                if (path.length == 1) {
                    return def;
                }
                if (!HierarchicalPropertyDefinition.class.isAssignableFrom(def.getClass())) continue;
                return BaseDefinition.getDefinition(((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(def)).getProperties(), Arrays.copyOfRange(path, 1, path.length));
            }
        }
        return null;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public long getVersion() {
        return this.version;
    }

    public Instant getCreationInstant() {
        return this.creationInstant;
    }

    public String getUserUniqueId() {
        return this.userUniqueId;
    }

    public String getLabel() {
        return this.label;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String getEndpointMethod() {
        return this.endpointMethod;
    }

    public String getNextVersionUniqueId() {
        return this.nextVersionUniqueId;
    }

    public boolean isSystem() {
        return this.system;
    }

    public List<SerializationMessage> getMessages() {
        return this.messages;
    }

    public List<PropertyDefinitionBlock> getPropertyBlocks() {
        return this.propertyBlocks;
    }

    public List<String> getPreviewPropertyIdentifiers() {
        return this.previewPropertyIdentifiers;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setCreationInstant(Instant creationInstant) {
        this.creationInstant = creationInstant;
    }

    public void setUserUniqueId(String userUniqueId) {
        this.userUniqueId = userUniqueId;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public void setEndpointMethod(String endpointMethod) {
        this.endpointMethod = endpointMethod;
    }

    public void setNextVersionUniqueId(String nextVersionUniqueId) {
        this.nextVersionUniqueId = nextVersionUniqueId;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public void setMessages(List<SerializationMessage> messages) {
        this.messages = messages;
    }

    public void setPropertyBlocks(List<PropertyDefinitionBlock> propertyBlocks) {
        this.propertyBlocks = propertyBlocks;
    }

    public void setPreviewPropertyIdentifiers(List<String> previewPropertyIdentifiers) {
        this.previewPropertyIdentifiers = previewPropertyIdentifiers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDefinition)) {
            return false;
        }
        BaseDefinition other = (BaseDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isSystem() != other.isSystem()) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Instant this$creationInstant = this.getCreationInstant();
        Instant other$creationInstant = other.getCreationInstant();
        if (this$creationInstant == null ? other$creationInstant != null : !((Object)this$creationInstant).equals(other$creationInstant)) {
            return false;
        }
        String this$userUniqueId = this.getUserUniqueId();
        String other$userUniqueId = other.getUserUniqueId();
        if (this$userUniqueId == null ? other$userUniqueId != null : !this$userUniqueId.equals(other$userUniqueId)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$messageCode = this.getMessageCode();
        String other$messageCode = other.getMessageCode();
        if (this$messageCode == null ? other$messageCode != null : !this$messageCode.equals(other$messageCode)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        String this$endpointMethod = this.getEndpointMethod();
        String other$endpointMethod = other.getEndpointMethod();
        if (this$endpointMethod == null ? other$endpointMethod != null : !this$endpointMethod.equals(other$endpointMethod)) {
            return false;
        }
        String this$nextVersionUniqueId = this.getNextVersionUniqueId();
        String other$nextVersionUniqueId = other.getNextVersionUniqueId();
        if (this$nextVersionUniqueId == null ? other$nextVersionUniqueId != null : !this$nextVersionUniqueId.equals(other$nextVersionUniqueId)) {
            return false;
        }
        List<SerializationMessage> this$messages = this.getMessages();
        List<SerializationMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<PropertyDefinitionBlock> this$propertyBlocks = this.getPropertyBlocks();
        List<PropertyDefinitionBlock> other$propertyBlocks = other.getPropertyBlocks();
        if (this$propertyBlocks == null ? other$propertyBlocks != null : !((Object)this$propertyBlocks).equals(other$propertyBlocks)) {
            return false;
        }
        List<String> this$previewPropertyIdentifiers = this.getPreviewPropertyIdentifiers();
        List<String> other$previewPropertyIdentifiers = other.getPreviewPropertyIdentifiers();
        return !(this$previewPropertyIdentifiers == null ? other$previewPropertyIdentifiers != null : !((Object)this$previewPropertyIdentifiers).equals(other$previewPropertyIdentifiers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        result = result * 59 + (this.isSystem() ? 79 : 97);
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Instant $creationInstant = this.getCreationInstant();
        result = result * 59 + ($creationInstant == null ? 43 : ((Object)$creationInstant).hashCode());
        String $userUniqueId = this.getUserUniqueId();
        result = result * 59 + ($userUniqueId == null ? 43 : $userUniqueId.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $messageCode = this.getMessageCode();
        result = result * 59 + ($messageCode == null ? 43 : $messageCode.hashCode());
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        String $endpointMethod = this.getEndpointMethod();
        result = result * 59 + ($endpointMethod == null ? 43 : $endpointMethod.hashCode());
        String $nextVersionUniqueId = this.getNextVersionUniqueId();
        result = result * 59 + ($nextVersionUniqueId == null ? 43 : $nextVersionUniqueId.hashCode());
        List<SerializationMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<PropertyDefinitionBlock> $propertyBlocks = this.getPropertyBlocks();
        result = result * 59 + ($propertyBlocks == null ? 43 : ((Object)$propertyBlocks).hashCode());
        List<String> $previewPropertyIdentifiers = this.getPreviewPropertyIdentifiers();
        result = result * 59 + ($previewPropertyIdentifiers == null ? 43 : ((Object)$previewPropertyIdentifiers).hashCode());
        return result;
    }

    public String toString() {
        return "BaseDefinition(uniqueId=" + this.getUniqueId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", creationInstant=" + this.getCreationInstant() + ", userUniqueId=" + this.getUserUniqueId() + ", label=" + this.getLabel() + ", messageCode=" + this.getMessageCode() + ", endpointUrl=" + this.getEndpointUrl() + ", endpointMethod=" + this.getEndpointMethod() + ", nextVersionUniqueId=" + this.getNextVersionUniqueId() + ", system=" + this.isSystem() + ", messages=" + this.getMessages() + ", propertyBlocks=" + this.getPropertyBlocks() + ", previewPropertyIdentifiers=" + this.getPreviewPropertyIdentifiers() + ")";
    }

    private static enum PROPERTY_FLAGS {
        AUTOFILL,
        AUTOQUERY,
        ENTITY_VOCABULARY,
        EXTERNAL_IDENTIFIER;

    }
}

