/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.registry.model.BasePropertyValue;
import java.util.regex.Pattern;

public class TextPropertyValue
extends BasePropertyValue<String> {
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    private static final long serialVersionUID = -137603852642783701L;

    public TextPropertyValue(String value) {
        this.setValue(value);
    }

    public TextPropertyValue(String value, String lang) {
        this.setValue(value);
        this.setLang(lang);
    }

    public TextPropertyValue(String value, String lang, String reference) {
        this.setValue(value);
        this.setLang(lang);
        this.setReference(reference);
    }

    @Override
    public boolean asBoolean() {
        return ((String)this.getValue()).equalsIgnoreCase("true");
    }

    @Override
    public boolean isValidEntityId() {
        return this.getValue() != null && UUID_PATTERN.matcher((CharSequence)this.getValue()).matches();
    }

    @Override
    public String toString() {
        return "TextPropertyValue()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextPropertyValue)) {
            return false;
        }
        TextPropertyValue other = (TextPropertyValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextPropertyValue;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public TextPropertyValue() {
    }
}

