/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.registry.model.PropertyValue;
import java.util.ArrayList;
import java.util.List;

public class PropertyValueList
implements PropertyValue {
    private static final long serialVersionUID = 7421623237153702261L;
    private List<PropertyValue> values;

    public void add(PropertyValue value) {
        this.ensureInitialized();
        this.values.add(value);
    }

    public void addAll(List<? extends PropertyValue> value) {
        this.ensureInitialized();
        this.values.addAll(value);
    }

    private void ensureInitialized() {
        if (this.values == null) {
            this.values = new ArrayList<PropertyValue>();
        }
    }

    public boolean isEmpty() {
        return this.values == null || this.values.isEmpty();
    }

    @Override
    public String asText() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        StringBuilder bldr = new StringBuilder();
        for (int i = 0; i < this.values.size(); ++i) {
            bldr.append(this.values.get(i).asText());
            if (i >= this.values.size() - 1) continue;
            bldr.append(", ");
        }
        return bldr.toString();
    }

    @Override
    public boolean isMultivalue() {
        return true;
    }

    @Override
    public List<PropertyValue> valuesAsList() {
        if (this.values == null) {
            return new ArrayList<PropertyValue>(0);
        }
        return this.values;
    }

    @Override
    public boolean asBoolean() {
        if (this.values == null || this.values.isEmpty()) {
            return false;
        }
        boolean b = true;
        for (PropertyValue v : this.values) {
            b = b && v.asBoolean();
        }
        return b;
    }

    @Override
    public String getLang() {
        return null;
    }

    public List<PropertyValue> getValues() {
        return this.values;
    }

    public void setValues(List<PropertyValue> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyValueList)) {
            return false;
        }
        PropertyValueList other = (PropertyValueList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PropertyValue> this$values = this.getValues();
        List<PropertyValue> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyValueList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PropertyValue> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "PropertyValueList(values=" + this.getValues() + ")";
    }
}

