/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.registry.model.BooleanPropertyValue;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.MissingProperty;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.helper.PropertyDefinitionHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.annotation.Transient;

public class PropertyList
implements Serializable {
    private static final long serialVersionUID = -6867411678627272950L;
    @Transient
    private List<PropertyDefinition> propertyDefinitions;
    private List<Property> properties;

    public PropertyList(List<PropertyDefinition> propertyDefinitions) {
        this.propertyDefinitions = propertyDefinitions;
    }

    public List<Property> get(PropertyDefinition propertyDefinition) {
        String[] pathWithEntity = propertyDefinition.getIdentifier().split("\\.");
        String[] getPath = Arrays.copyOfRange(pathWithEntity, 1, pathWithEntity.length);
        return this.getByIdentifier(getPath);
    }

    public List<Property> getByIdentifier(String[] identifier) {
        return this.getByIdentifierInProperties(this.getProperties(), identifier);
    }

    private List<Property> getByIdentifierInProperties(List<Property> properties, String[] identifier) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (properties != null) {
            for (Property prop : properties) {
                if (!prop.getLabel().equals(identifier[0])) continue;
                if (identifier.length == 1) {
                    result.add(prop);
                    continue;
                }
                result.addAll(this.getByIdentifierInPropertyLists(prop.getProperties(), Arrays.copyOfRange(identifier, 1, identifier.length)));
            }
        }
        return result;
    }

    private List<Property> getByIdentifierInPropertyLists(List<PropertyList> propertyLists, String[] identifier) {
        return propertyLists.stream().flatMap(pl -> this.getByIdentifierInProperties(pl.getProperties(), identifier).stream()).toList();
    }

    public Property get(String property) {
        String[] path = property.split("\\.");
        return this.get(path);
    }

    public Property get(String[] path) {
        if (this.properties != null) {
            for (Property prop : this.properties) {
                IndexedField idxF = new IndexedField(path[0]);
                if (!prop.getLabel().equals(idxF.getFieldname())) continue;
                if (idxF.hasIndex()) {
                    return prop.getProperty(idxF.getIndex()).get(Arrays.copyOfRange(path, 1, path.length));
                }
                return prop;
            }
        }
        return MissingProperty.getInstance();
    }

    public void set(String property, boolean value) {
        this.set(property, (PropertyValue)new BooleanPropertyValue(value));
    }

    public void set(String property, int value) {
        this.set(property, (PropertyValue)new IntegerPropertyValue(value));
    }

    public void set(String property, String value) {
        this.set(property, (PropertyValue)new TextPropertyValue(value));
    }

    public void set(String property, String value, boolean append) {
        this.set(property, (PropertyValue)new TextPropertyValue(value), append);
    }

    public void set(String property, double value) {
        this.set(property, (PropertyValue)new DoublePropertyValue(value));
    }

    public void set(String property, PropertyValue value) {
        String[] path = property.split("\\.");
        this.set(path, value);
    }

    public void set(String property, PropertyValue value, boolean append) {
        String[] path = property.split("\\.");
        this.set(path, value, append);
    }

    public void set(String[] path, PropertyValue value) {
        this.set(path, value, false);
    }

    public void set(String[] path, PropertyValue value, boolean append) {
        Optional<PropertyDefinition> pd;
        IndexedField idxF = new IndexedField(path[0]);
        if (this.properties != null) {
            for (Property prop : this.properties) {
                if (!prop.getLabel().equals(idxF.getFieldname())) continue;
                this.set(prop, path, value, append);
                return;
            }
        }
        PropertyImpl newProp = new PropertyImpl();
        if (this.getPropertyDefinitions() != null && (pd = this.getPropertyDefinitions().stream().filter(d -> d.getName().equals(idxF.getFieldname())).findFirst()).isPresent()) {
            newProp.setDefinition(pd.get());
        }
        newProp.setLabel(idxF.getFieldname());
        this.set(newProp, path, value, append);
        this.add(newProp);
    }

    private void set(Property property, String[] path, PropertyValue value, boolean append) {
        IndexedField idxF = new IndexedField(path[0]);
        if (path.length == 1 && !idxF.hasIndex()) {
            if (append) {
                property.addValue(PropertyDefinitionHelper.transformIfRequiredAndPossible(property.getDefinition(), value));
            } else {
                property.setValue(PropertyDefinitionHelper.transformIfRequiredAndPossible(property.getDefinition(), value));
            }
        } else if (path.length == 1) {
            if (append) {
                property.addValue(this.getOrCreateValueListWithValue(property, idxF.getIndex(), PropertyDefinitionHelper.transformIfRequiredAndPossible(property.getDefinition(), value)));
            } else {
                property.setValue(this.getOrCreateValueListWithValue(property, idxF.getIndex(), PropertyDefinitionHelper.transformIfRequiredAndPossible(property.getDefinition(), value)));
            }
        } else {
            int idx = idxF.hasIndex() ? idxF.getIndex() : 0;
            property.setProperties(this.createOrMergePropertyLists(property.getProperties(), idx));
            if (property.getProperties().get(idx) == null) {
                List<PropertyDefinition> pd = null;
                if (property.getDefinition() != null && property.getDefinition().isHierarchical()) {
                    pd = ((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(property.getDefinition())).getProperties();
                }
                property.getProperties().set(idx, new PropertyList(pd));
            }
            property.getProperty(idx).set(Arrays.copyOfRange(path, 1, path.length), value);
        }
    }

    private List<PropertyList> createOrMergePropertyLists(List<PropertyList> source, int index) {
        if (source != null && source.size() > index + 1) {
            return source;
        }
        ArrayList<PropertyList> target = new ArrayList<PropertyList>(index + 1);
        for (int i = 0; i <= index; ++i) {
            if (source != null && source.size() > i) {
                target.add(source.get(i));
                continue;
            }
            target.add(null);
        }
        return target;
    }

    private PropertyValueList getOrCreateValueListWithValue(Property property, int index, PropertyValue value) {
        PropertyValueList valueList = property.getValue() == null || !PropertyValueList.class.isAssignableFrom(property.getValue().getClass()) ? new PropertyValueList() : (PropertyValueList)PropertyValueList.class.cast(property.getValue());
        valueList.setValues(this.mergeValueListsWithValue(valueList.getValues(), index, value));
        return valueList;
    }

    private List<PropertyValue> mergeValueListsWithValue(List<PropertyValue> source, int index, PropertyValue value) {
        if (source != null && source.size() > index + 1) {
            source.set(index, value);
            return source;
        }
        ArrayList<PropertyValue> target = new ArrayList<PropertyValue>(index + 1);
        for (int i = 0; i <= index; ++i) {
            if (i == index) {
                target.add(value);
                continue;
            }
            if (source != null && source.size() > i) {
                target.add(source.get(i));
                continue;
            }
            target.add(null);
        }
        return target;
    }

    public void addAll(Collection<? extends Property> properties) {
        this.ensurePropertiesInitialized();
        this.properties.addAll(properties);
    }

    public void add(Property property) {
        this.ensurePropertiesInitialized();
        this.properties.add(property);
    }

    private void ensurePropertiesInitialized() {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
    }

    public List<PropertyDefinition> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setPropertyDefinitions(List<PropertyDefinition> propertyDefinitions) {
        this.propertyDefinitions = propertyDefinitions;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyList)) {
            return false;
        }
        PropertyList other = (PropertyList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PropertyDefinition> this$propertyDefinitions = this.getPropertyDefinitions();
        List<PropertyDefinition> other$propertyDefinitions = other.getPropertyDefinitions();
        if (this$propertyDefinitions == null ? other$propertyDefinitions != null : !((Object)this$propertyDefinitions).equals(other$propertyDefinitions)) {
            return false;
        }
        List<Property> this$properties = this.getProperties();
        List<Property> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PropertyDefinition> $propertyDefinitions = this.getPropertyDefinitions();
        result = result * 59 + ($propertyDefinitions == null ? 43 : ((Object)$propertyDefinitions).hashCode());
        List<Property> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "PropertyList(propertyDefinitions=" + this.getPropertyDefinitions() + ", properties=" + this.getProperties() + ")";
    }

    public PropertyList() {
    }

    private class IndexedField {
        private static final Pattern INDEXED_FIELD_PATTERN = Pattern.compile("([^#\\[]+)(\\[([^\\]]+)\\])?(\\#([^\\[]+))?");
        private String fieldname = null;
        private Integer index = null;
        private String subpropSelector = null;

        public IndexedField(String name) {
            Matcher matcher = INDEXED_FIELD_PATTERN.matcher(name);
            if (matcher.find()) {
                if (matcher.groupCount() > 0) {
                    this.fieldname = matcher.group(1);
                }
                if (matcher.groupCount() > 2) {
                    Integer n = this.index = matcher.group(3) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(3)));
                }
                if (matcher.groupCount() > 4) {
                    this.subpropSelector = matcher.group(5);
                }
            }
        }

        public boolean hasIndex() {
            return this.index != null;
        }

        public String getFieldname() {
            return this.fieldname;
        }

        public Integer getIndex() {
            return this.index;
        }

        public String getSubpropSelector() {
            return this.subpropSelector;
        }

        public void setFieldname(String fieldname) {
            this.fieldname = fieldname;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public void setSubpropSelector(String subpropSelector) {
            this.subpropSelector = subpropSelector;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexedField)) {
                return false;
            }
            IndexedField other = (IndexedField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$index = this.getIndex();
            Integer other$index = other.getIndex();
            if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
                return false;
            }
            String this$fieldname = this.getFieldname();
            String other$fieldname = other.getFieldname();
            if (this$fieldname == null ? other$fieldname != null : !this$fieldname.equals(other$fieldname)) {
                return false;
            }
            String this$subpropSelector = this.getSubpropSelector();
            String other$subpropSelector = other.getSubpropSelector();
            return !(this$subpropSelector == null ? other$subpropSelector != null : !this$subpropSelector.equals(other$subpropSelector));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IndexedField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $index = this.getIndex();
            result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
            String $fieldname = this.getFieldname();
            result = result * 59 + ($fieldname == null ? 43 : $fieldname.hashCode());
            String $subpropSelector = this.getSubpropSelector();
            result = result * 59 + ($subpropSelector == null ? 43 : $subpropSelector.hashCode());
            return result;
        }

        public String toString() {
            return "PropertyList.IndexedField(fieldname=" + this.getFieldname() + ", index=" + this.getIndex() + ", subpropSelector=" + this.getSubpropSelector() + ")";
        }
    }
}

