/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Transient;

public class PropertyImpl
implements Property {
    private static final long serialVersionUID = 8048151962532351314L;
    private String label;
    @Transient
    private PropertyDefinition definition;
    private PropertyValue value;
    private List<PropertyList> properties;

    @Override
    public PropertyList getProperty(int index) {
        if (this.properties == null || this.properties.size() < index + 1) {
            return null;
        }
        return this.properties.get(index);
    }

    @Override
    public List<PropertyValue> valuesAsList() {
        return this.value == null ? new ArrayList(0) : this.value.valuesAsList();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public void removeValues(List<PropertyValue> removeValues) {
        if (this.value != null && removeValues.contains(this.value)) {
            this.value = null;
        } else if (this.value != null && PropertyValueList.class.isAssignableFrom(this.value.getClass())) {
            ((PropertyValueList)PropertyValueList.class.cast(this.value)).getValues().removeAll(removeValues);
        }
    }

    @Override
    public void removeValue(PropertyValue removeValue) {
        if (this.value != null && this.value.equals(removeValue)) {
            this.value = null;
        } else if (this.value != null && PropertyValueList.class.isAssignableFrom(this.value.getClass())) {
            ((PropertyValueList)PropertyValueList.class.cast(this.value)).getValues().remove(removeValue);
        }
    }

    @Override
    public void addValue(PropertyValue value) {
        if (this.getValue() == null) {
            this.setValue(value);
        } else if (this.getValue().isMultivalue()) {
            ((PropertyValueList)PropertyValueList.class.cast(this.getValue())).addAll(value.valuesAsList());
        } else {
            PropertyValueList pv = new PropertyValueList();
            pv.add(this.getValue());
            pv.addAll(value.valuesAsList());
            this.setValue(pv);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public PropertyValue getValue() {
        return this.value;
    }

    @Override
    public List<PropertyList> getProperties() {
        return this.properties;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setDefinition(PropertyDefinition definition) {
        this.definition = definition;
    }

    @Override
    public void setValue(PropertyValue value) {
        this.value = value;
    }

    @Override
    public void setProperties(List<PropertyList> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        PropertyDefinition this$definition = this.getDefinition();
        PropertyDefinition other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !((Object)this$definition).equals(other$definition)) {
            return false;
        }
        PropertyValue this$value = this.getValue();
        PropertyValue other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<PropertyList> this$properties = this.getProperties();
        List<PropertyList> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        PropertyDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : ((Object)$definition).hashCode());
        PropertyValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<PropertyList> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "PropertyImpl(label=" + this.getLabel() + ", definition=" + this.getDefinition() + ", value=" + this.getValue() + ", properties=" + this.getProperties() + ")";
    }
}

